using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Media;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace malfnctioningAlarmClock
{
    public partial class Form1 : Form
    {
        array[] Alarm = new array[5];
        Random randomNumber = new Random();
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            dayCombo.Text = DateTime.Now.Day.ToString() + ".";
            monthCombo.Text = getMonthName(DateTime.Now.Month);
            hourBox.Text = DateTime.Now.Hour.ToString();
            minuteBox.Text = DateTime.Now.Minute.ToString() ;
            dayCombo.Select(0, 0);
            createArray();
            if (!System.IO.File.Exists(Application.StartupPath + "\\sound.wav"))
            {
                MessageBox.Show("Finner ikke filen: " + Application.StartupPath + "\\sound.wav. Programmet avsluttes.", "Error: 404");
                this.Close();
            }
        }
        void createArray()
        {
            for (int ind = 0; ind < 5; ind++)
            {
                Alarm[ind] = new array();
                Alarm[ind].set = false;
            }
        }
        string getMonthName(int nr)
        {
            switch (nr)
            {
                case 1:
                    return "Januar";
                case 2:
                    return "Februar";
                case 3:
                    return "Mars";
                case 4:
                    return "April";
                case 5:
                    return "Mai";
                case 6:
                    return "Juni";
                case 7:
                    return "Juli";
                case 8:
                    return "August";
                case 9:
                    return "September";
                case 10:
                    return "Oktober";
                case 11:
                    return "November";
                case 12:
                    return "Desember";
            }
            return "WTF?";
        }
        int getMonthNumber(string name)
        {
            switch (name)
            {
                case "Januar":
                    return 1;
                case "Februar":
                    return 2;
                case "Mars":
                    return 3;
                case "April":
                    return 4;
                case "Mai":
                    return 5;
                case "Juni":
                    return 6;
                case "Juli":
                    return 7;
                case "August":
                    return 8;
                case "September":
                    return 9;
                case "Oktober":
                    return 10;
                case "November":
                    return 11;
                case "Desember":
                    return 12;
            }
            return 1337;
        }

        private void addAlarmButton_Click(object sender, EventArgs e)
        {
            if (validInput())
                addAlarm(createDateTime());
            else
                MessageBox.Show("Det oppstod et error! Velg en gyldig dato med listene, skriv inn et klokkeslett som eksisterer og prv p nytt.", "Ikke gyldig dato/format");
        }
        bool validInput()
        {
            try
            {
                int hour = 0;
                if (!int.TryParse(hourBox.Text, out hour))
                    return false;

                int day = 0;
                if (!int.TryParse(dayCombo.Text.Substring(0, dayCombo.Text.Length - 1), out day))
                    return false;

                int minute = 0;
                if (!int.TryParse(minuteBox.Text, out minute))
                    return false;

                int month = getMonthNumber(monthCombo.Text);
                if (month == 1337)
                    return false;


                int year = DateTime.Now.Year;
                if (month < DateTime.Now.Month)
                    year = DateTime.Now.Year + 1;
                if (month == DateTime.Now.Month && day < DateTime.Now.Day)
                    year = DateTime.Now.Year + 1;
                if (month == DateTime.Now.Month && day == DateTime.Now.Day && hour < DateTime.Now.Hour)
                    year = DateTime.Now.Year + 1;
                if (month == DateTime.Now.Month && day == DateTime.Now.Day && hour == DateTime.Now.Hour && minute <= DateTime.Now.Minute)
                    year = DateTime.Now.Year + 1;

                if (hour > 23 || hour < 0)
                    return false;
                if (minute > 59 || minute < 0)
                    return false;
                if (day > DateTime.DaysInMonth(year, month))
                    return false;

            }
            catch (Exception)
            {
                return false;
            }


            return true;
        }
        void addAlarm(DateTime realtime)
        {
            int nr = 4;
            if (!Alarm[3].set)
                nr = 3;
            if (!Alarm[2].set)
                nr = 2;
            if (!Alarm[1].set)
                nr = 1;
            if (!Alarm[0].set)
                nr = 0;
            Alarm[nr].set = true;
            Alarm[nr].realTime = realtime;
            TimeSpan between = new TimeSpan();
            between = realtime.Subtract(DateTime.Now);
            TimeSpan difference;
            if (between.TotalHours < 6)
            {
                difference = new TimeSpan(randomNumber.Next(-4, 0), randomNumber.Next(-59, 0), 0);
            }
            else
                difference = new TimeSpan(randomNumber.Next(-4, 5), randomNumber.Next(-59, 60), 0);
            Alarm[nr].alarmTime = realtime.Subtract(difference);
            writeListBoxContent();
        }
        DateTime createDateTime()
        {
            int hour = Convert.ToInt32(hourBox.Text);
            int day = Convert.ToInt32(dayCombo.Text.Substring(0, dayCombo.Text.Length - 1));
            int minute = Convert.ToInt32(minuteBox.Text);
            int month = getMonthNumber(monthCombo.Text);
            int year = DateTime.Now.Year;
            if (month < DateTime.Now.Month)
                year = DateTime.Now.Year + 1;
            if (month == DateTime.Now.Month && day < DateTime.Now.Day)
                year = DateTime.Now.Year + 1;
            if (month == DateTime.Now.Month && day == DateTime.Now.Day && hour < DateTime.Now.Hour)
                year = DateTime.Now.Year + 1;
            if (month == DateTime.Now.Month && day == DateTime.Now.Day && hour == DateTime.Now.Hour && minute <= DateTime.Now.Minute)
                year = DateTime.Now.Year + 1;
            DateTime realtime = new DateTime(year, month, day, hour, minute, 0);
            return realtime;
        }
        void writeListBoxContent()
        {
            alarmsList.Items.Clear();
            for (int ind = 0; ind < 5; ind++)
            {
                if (Alarm[ind].set)
                    alarmsList.Items.Add("Alarm @ ca: " + Convert.ToString(Alarm[ind].realTime));
            }
        }

        private void removeAlarmButton_Click(object sender, EventArgs e)
        {
            if (alarmsList.SelectedItem == null)
                MessageBox.Show("Du har ikke valgt en alarm  slette...", "Error");
            else
            {
                deleteAlarm();
                writeListBoxContent();
            }
        }
        void deleteAlarm()
        {
            for (int ind = 0; ind < 5; ind++)
            {
                if (Alarm[ind].set)
                {
                    if ("Alarm @ ca: " + Convert.ToString(Alarm[ind].realTime) == alarmsList.SelectedItem.ToString())
                    {
                        Alarm[ind].set = false;
                        return;
                    }
                }
            }
        }

        private void triggerAlarmTimer_Tick(object sender, EventArgs e)
        {
            DateTime now = DateTime.Now;
            for (int ind = 0; ind < 5; ind++)
            {
                DateTime alarm = Alarm[ind].alarmTime;
                if (alarm.Year == now.Year && alarm.Day == now.Day && alarm.Hour == now.Hour && alarm.Minute == now.Minute)
                    makeNoise();
            }
        }
        void makeNoise()
        {
            SoundPlayer mplayer = new SoundPlayer();
            mplayer.SoundLocation = Application.StartupPath + "\\sound.wav";
            mplayer.PlayLooping();
            MessageBox.Show(Environment.UserName + ", du m vakna, indianarere kjem", "Good morning! (Or Evening, how the heck should I know?)");
            mplayer.Stop();
            mplayer.Dispose();
        }
    }
}